﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace CashierCrisis.Behaviors
{
    [DefaultProperty("Times")]
    public class Repeat : Decorator
    {
        [Category("Settings"), Description("Times this decorator's child will repeat.")]
        public int Times { get; set; }

        [Category("Settings"), Description("If true this decorator will continue to repeat its child.")]
        public bool Forever { get; set; }

        public int Count { private get; set; }

        public Repeat()
        {
            Times = 0;
            Count = 0;
            Forever = false;
        }

        public override Status Execute(Microsoft.Xna.Framework.GameTime gameTime)
        {
            if (!Forever && Count >= Times)
            {
                return Completed;
            }

            if (Child != null)
            {
                Status status = Child.Execute(gameTime);

                if (status == Status.Completed || status == Status.Failed)
                {
                    Count++;
                }

                return Running;
            }

            return Failed;
        } 
    }
}
